% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{OpenEOClient}
\alias{OpenEOClient}
\title{openEO client class}
\description{
An R6Class that interacts with an openEO compliant back-end.
}
\section{Fields}{

\describe{
\item{\code{user_id}}{The user_id obtained after authentication}

\item{\code{api.mapping}}{The mapping of the API endpoints and the back-end published ones}
}}

\section{Methods}{

\describe{
\item{\verb{$new(host=NULL)}}{the constructor with an optional host URL to connect to}
\item{\verb{$getBackendEndpoint(endpoint_name)}}{returns the URL for the requested endpoint tag}
\item{\verb{$request(tag,parameters=NULL,authorized=FALSE, ...)}}{performs the desired HTTP request by endpoint tag with
path parameters and whether or not authorization (access_token) is necessary}
\item{\verb{$isConnected()}}{whether or not the client has a host set}
\item{\verb{$isLoggedIn()}}{returns a logical describing whether the user is logged in}
\item{\verb{$getHost()}}{returns the host URL}
\item{\verb{$stopIfNotConnected()}}{throws an error if called and the client is not connected}
\item{\verb{$connect(url=NULL,version=NULL)}}{connects to a specific version of a back-end}
\item{\verb{$disconnect()}}{disconnects from the back-end by logout and clearing of active back-end package variables}
\item{\verb{$api_version()}}{returns the openEO API version this client is compliant to}
\item{\verb{$login(user=NULL, password=NULL,provider=NULL,config=NULL)}}{creates an \code{\link[=IAuth]{IAuth()}} object}
\item{\verb{$logout()}}{invalidates the access_token and terminates the current session}
\item{\verb{$getAuthClient()}}{returns the authentication client}
\item{\verb{$setAuthClient(value)}}{sets the authentication client if it was configured and set externally}
\item{\verb{$getCapabilities()}}{service exploration to retrieve the supported openEO endpoints}
\item{\verb{$getId()}}{returns the ID of the Connection as stated in the getCapabilities document}
\item{\verb{$getTitle()}}{returns the title of the connection as stated in the getCapabilities document}
}
}

\section{Arguments}{

\describe{
\item{\code{host}}{the openEO host URL}
\item{\code{endpoint_name}}{the endpoint tag the client uses for the endpoints}
\item{\code{tag}}{endpoint tag}
\item{\code{parameters}}{named list of values to be replaced in the endpoint}
\item{\code{authorized}}{whether or not the endpoint requires authentication via access_token}
\item{\code{url}}{url of an openEO back-end either directly versioned or with the separate version statement}
\item{\code{version}}{the openEO API version to be used, or a list of available API versions if set to NULL}
\item{\code{user}}{the user name}
\item{\code{password}}{the user password}
\item{\code{value}}{an authentication object}
}
}

