% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onelogin.R
\name{onelogin}
\alias{onelogin}
\title{Define a 'OneLogin' Connection}
\usage{
onelogin(region = "US", client_id = Sys.getenv("ONELOGIN_CLIENT_ID"),
  client_secret = Sys.getenv("ONELOGIN_CLIENT_SECRET"))
}
\arguments{
\item{region}{either "US" or "EU", defaults to "US"}

\item{client_id}{'OneLogin' client ID, defaults to Sys.getenv("ONELOGIN_CLIENT_ID")}

\item{client_secret}{'OneLogin' client secret, defaults to Sys.getenv("ONELOGIN_CLIENT_SECRET")}
}
\value{
a 'OneLogin' connection
}
\description{
Define a connection to the 'OneLogin' API. Please see the \href{https://developers.onelogin.com/api-docs/1/getting-started/dev-overview}{API documentation}
for details on using this API and on getting credentials.
}
\examples{
onelogin(region = "US", "client_id", "client_secret")
}
