% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbc-connection.R
\name{quote_value}
\alias{quote_value}
\title{Quote special character when connecting}
\usage{
quote_value(x)
}
\arguments{
\item{x}{A string to quote.}
}
\value{
A quoted string, wrapped in \code{I()}.
}
\description{
When connecting to a database using odbc, all the arguments are concatenated
into a single connection string that looks like \verb{name1=value1;name2=value2}.
That means if your value contains \code{=} or \verb{;} then it needs to be quoted.
Other rules mean that you need to quote any values that starts or ends with
white space, or contains \verb{\{} or \verb{\}}.

This function quotes a string in a way that should work for most drivers,
but unfortunately there doesn't seem to be an approach that works everywhere.
If this function doesn't work for you, you'll need to carefully read the
docs for your driver.
}
\examples{
quote_value("abc")
quote_value("ab'c")

# Real usage is more likely to look like:
\dontrun{
library(DBI)

con <- dbConnect(
  odbc::odbc(),
  dsn = "reallycooldatabase"
  password = odbc::quote_value(Sys.getenv("MY_PASSWORD"))
)
}
}
