% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limpar_nomes.R
\name{limpar_nomes}
\alias{limpar_nomes}
\alias{find_and_clean_NAnames_and_extra_spaces}
\title{Limpa e Analisa Nomes em um data.table}
\usage{
limpar_nomes(d, s)

find_and_clean_NAnames_and_extra_spaces(d, s)
}
\arguments{
\item{d}{Um objeto `data.table`.}

\item{s}{O nome da coluna (em string) dentro de `d` que contém os nomes a serem processados.}
}
\value{
Um `data.table` modificado, contendo a coluna original, uma nova coluna
  com sufixo "_clean" com os nomes limpos, e colunas booleanas indicando
  a detecção de cada tipo de problema (ex: `falecido`, `cartorio`).
}
\description{
Processa uma coluna de nomes em um `data.table`, aplicando uma série de
regras de limpeza para identificar e corrigir/marcar problemas comuns como
menções a "FALECIDO", "CARTORIO", erros de digitação, espaços indevidos, etc.
}
\details{
A função executa os seguintes passos principais:
\enumerate{
  \item Cria uma cópia da coluna de nomes para limpeza.
  \item Detecta e trata menções a "FALECIDO(A)".
  \item Detecta e trata menções a "CARTORIO" e nomes de cidades comuns em 
  registros.
  \item Corrige espaçamento perto de caracteres especiais  
  com `limpa_espaco_acento_til_apostrofe`.
  \item Identifica e trata nomes contendo termos problemáticos como "PAI", 
  "MAE", "SEM", "NAO", exceto em contextos aceitáveis.
  \item Identifica e trata casos de "NADA CONSTA" e variações.
  \item Corrige E, DA, DE e variantes com caracter prévio indevido 
  (ex: "EDAS" para "DAS" se aplicável).
  \item Remove saudações como "SR.", "SRA.".
  \item Remove termos como "IGNORADO", "DESCONHECIDO".
  \item Remove repetições de partículas de ligação (ex: "DE DE").
  \item Limpa letras repetidas no início ou meio de palavras.
}
}
\examples{
# Supondo que 'meu_DT' é um data.table com uma coluna 'nome_sujo'
DT_exemplo <- data.table::data.table(
id = 1:3,
nome_sujo = c("MARIA FALECIDA SSILVA", "CARTORIO DE PAZ", "JOAO D ARC")
)
DT_limpo <- limpar_nomes(DT_exemplo, "nome_sujo")
print(DT_limpo)

}
