% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppv_functions.R
\name{.get_density}
\alias{.get_density}
\title{Function to estimate density needed to evaluate standard errors.}
\usage{
.get_density(
  x,
  c0,
  bounded_kernel = FALSE,
  x_name = "train_pred",
  y_name = "train_y",
  nested_cv = FALSE,
  prediction_list = NULL,
  folds = NULL,
  maxDens = 1000,
  ...
)
}
\arguments{
\item{x}{An entry in prediction_list.}

\item{c0}{The point at which the density estimate is evaluated.}

\item{bounded_kernel}{Should a bounded kernel be used? Default is \code{FALSE}.}

\item{x_name}{Name of variable to compute density of.}

\item{y_name}{Name of variable to stratify density computation on.}

\item{nested_cv}{Use nested CV to estimate density?}

\item{prediction_list}{Properly formatted list of predictions.}

\item{folds}{Cross-validation fold assignments.}

\item{maxDens}{The maximum allowed value for the density.}

\item{...}{Other options (not currently used)}
}
\description{
Function to estimate density needed to evaluate standard errors.
}
