% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanes}
\alias{nhanes}
\title{Download an NHANES table and return as a data frame.}
\usage{
nhanes(
  nh_table,
  includelabels = FALSE,
  translated = TRUE,
  cleanse_numeric = FALSE,
  nchar = 128,
  adjust_timeout = TRUE
)
}
\arguments{
\item{nh_table}{The name of the specific table to retrieve.}

\item{includelabels}{If TRUE, then include SAS labels as variable
attribute (default = FALSE).}

\item{translated}{translated whether the variables are translated.}

\item{cleanse_numeric}{Logical flag. If \code{TRUE}, some special
codes in numeric variables, such as \sQuote{Refused} and
\sQuote{Don't know} will be converted to \code{NA}.}

\item{nchar}{Maximum length of translated string (default =
128). Ignored if translated=FALSE.}

\item{adjust_timeout}{Typically a logical flag indicating whether
the default \code{\link{download.file}} timeout option should be
adjusted by taking into account the size of the file to be
downloaded, as reported by the server. The value can also be a
positive numeric value, in which case it is used as a further
multiplicative factor for the default calculation.}
}
\value{
The table is returned as a data frame.
}
\description{
Use to download NHANES data tables that are in SAS format.
}
\details{
Downloads a table from the NHANES website as is, i.e. in
  its entirety with no modification or cleansing. If the
  environment variable \code{NHANES_TABLE_BASE} was set during
  startup, the value of this variable is used as the base URL
  instead of \url{https://wwwn.cdc.gov} (this allows the use of a
  local or alternative mirror of the CDC data). NHANES tables are
  stored in SAS '.XPT' format but are imported as a data frame.
  The \code{nhanes} function cannot be used to import limited
  access data.
}
\examples{
\donttest{bpx_e = nhanes('BPX_E')}
\donttest{dim(bpx_e)}
\donttest{folate_f = nhanes('FOLATE_F', includelabels = TRUE)}
\donttest{dim(folate_f)}
}
