% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_contracts.R
\name{load_contracts}
\alias{load_contracts}
\title{Load Historical Player Contracts from OverTheCap.com}
\usage{
load_contracts(file_type = getOption("nflreadr.prefer", default = "rds"))
}
\arguments{
\item{file_type}{One of \code{"rds"}, \code{"qs"}, \code{"csv"}, or \code{"parquet"}.
Can also be set globally with options(nflreadr.prefer)}
}
\value{
A tibble of active and non-active NFL player contracts.
}
\description{
Loads player contracts from OverTheCap.com
}
\examples{
\dontshow{.for_cran()}
\donttest{
try({ # prevents cran errors
  load_contracts()
})
}

}
\seealso{
\url{https://overthecap.com/contract-history} for a web version of the data

\url{https://nflreadr.nflverse.com/articles/dictionary_contracts.html} for a web version of the dictionary

\code{\link{dictionary_contracts}} for the data dictionary as bundled within the package

Issues with this data should be filed here: \url{https://github.com/nflverse/rotc}
}
