% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-pipeline.R
\name{add_parameter_keys}
\alias{add_parameter_keys}
\title{Add parameter keys names for later use in summarizing model effects}
\usage{
add_parameter_keys(.df, parameter_group, parameter_name)
}
\arguments{
\item{.df}{The original \code{data.frame}(e.g., base data set). If part of
set of add_* decision functions in a pipeline, the base data will be passed
along as an attribute.}

\item{parameter_group}{character, a name for the parameter of interest}

\item{parameter_name}{quoted or unquoted names of variables involved in a
particular parameter of interest. Usually this is just a variable in your
model (e.g., a main effect of your iv). However, it could also be an
interaction term or some other term. You can use \code{glue} syntax to
specify an effect that might use alternative versions of the same variable.}
}
\value{
a \code{data.frame} with three columns: type, group, and code. Type
indicates the decision type, group is a decision, and the code is the
actual code that will be executed. If part of a pipe, the current set of
decisions will be appended as new rows.
}
\description{
Add parameter keys names for later use in summarizing model effects
}
\examples{

library(tidyverse)
library(multitool)

# Simulate some data
the_data <-
  data.frame(
    id   = 1:500,
    iv1  = rnorm(500),
    iv2  = rnorm(500),
    iv3  = rnorm(500),
    mod1 = rnorm(500),
    mod2 = rnorm(500),
    mod3 = rnorm(500),
    cov1 = rnorm(500),
    cov2 = rnorm(500),
    dv1  = rnorm(500),
    dv2  = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

the_data |>
  add_variables("ivs", iv1, iv2, iv3) |>
  add_variables("dvs", dv1, dv2) |>
  add_variables("mods", starts_with("mod")) |>
  add_model("linear model", lm({dvs} ~ {ivs} * {mods})) |>
  add_parameter_keys("my_interaction", "{ivs}:{mods}") |>
  add_parameter_keys("my_main_effect", {ivs})
}
