% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtual_ecologist.R
\name{virtual_ecologist}
\alias{virtual_ecologist}
\title{Virtual Ecologist}
\usage{
virtual_ecologist(
  obj,
  type = c("random_one_layer", "random_all_layers", "from_data"),
  sites = NULL,
  prop = 0.01,
  obs_error = c("rlnorm", "rbinom"),
  obs_error_param = NULL
)
}
\arguments{
\item{obj}{An object created by the \code{\link[=sim_com]{sim_com()}} function,
containing simulation data.}

\item{type}{character vector of length 1; describes the sampling type
(case-sensitive):
\itemize{
\item \code{"random_one_layer"} - random selection of cells for which abundances
are sampled; the same set of selected cells is used across all time steps.
\item \code{"random_all_layers"} - random selection of cells for which abundances
are sampled; a new set of cells is selected for each time step.
\item \code{"from_data"} - user-defined selection of cells for which abundances
are sampled; the user is required to provide a \code{data.frame} containing
three columns: \code{"x"}, \code{"y"} and \code{"time"}.
}}

\item{sites}{An optional data frame specifying the sites for data extraction.
This data frame must contain three columns: \code{x}, \code{y} and \code{time}.}

\item{prop}{A numeric value between 0 and 1. The proportion of cells to randomly
sample from the raster.}

\item{obs_error}{character vector of length 1; type of the distribution
that defines the observation process: "\code{\link[stats:Lognormal]{rlnorm}}"
(log-normal distribution) or "\code{\link[stats:Binomial]{rbinom}}" (binomial distribution).}

\item{obs_error_param}{numeric vector of length 1; standard deviation
(on a log scale) of the random noise in the observation process when
\code{"rlnorm"} is used, or probability of detection (success) when \code{"rbinom"} is used.}
}
\value{
A data frame with 6 columns:
\itemize{
\item \code{id}: unique cell identifier (factor)
\item \code{x}, \code{y}: sampled cell coordinates
\item \code{species}: species number or name
\item \code{time}: sampled time step
\item \code{n}: sampled abundance
}
}
\description{
Organizes and extracts community data from a simulated community object
based on one of three sampling methods: random proportion, constant random
sites, or user-provided sites.
}
\examples{
# Read simulated community data from the mrangr package
simulated_com <- get_simulated_com()

# Option 1: Randomly sample sites (the same for each year)
sampled_data_01 <- virtual_ecologist(simulated_com)
head(sampled_data_01)

# Option 2: Randomly sample sites (different for each year)
sampled_data_02 <- virtual_ecologist(simulated_com, type = "random_all_layers")
head(sampled_data_02)

# Option 3: Sample sites based on user-provided data frame
custom_sites <- data.frame(
  x = c(250500, 252500, 254500),
  y = c(600500, 602500, 604500),
  time = c(1, 10, 20)
)
sampled_data_03 <- virtual_ecologist(simulated_com, sites = custom_sites)
head(sampled_data_03)

# Option 4. Add noise - "rlnorm"
sampled_data_04 <- virtual_ecologist(
  simulated_com,
  sites = custom_sites,
  obs_error = "rlnorm",
  obs_error_param = log(1.2)
)
head(sampled_data_04)

# Option 5. Add noise - "rbinom"
sampled_data_05 <- virtual_ecologist(
  simulated_com,
  sites = custom_sites,
  obs_error = "rbinom",
  obs_error_param = 0.8
)
head(sampled_data_05)


}
