% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{splice_time.OnsetsDifference}
\alias{splice_time.OnsetsDifference}
\title{Generate spliced timeline using an \code{OnsetsDifference} object}
\usage{
\method{splice_time}{OnsetsDifference}(x, window_duration, metres = NULL, make.unique = TRUE, ...)
}
\arguments{
\item{x}{\code{OnsetsDifference} object.}

\item{window_duration}{duration of window around onset point in seconds.}

\item{metres}{vector of metres to subset.}

\item{make.unique}{give unique names to each segment?}

\item{...}{passed to \code{\link[=make.unique]{make.unique()}}.}
}
\value{
a \code{Splice} object.
}
\description{
Generate spliced timeline using an \code{OnsetsDifference} object
}
\examples{
r <- get_sample_recording()
o1 <- get_onsets_selected_data(r)
po1 <- difference_onsets(o1, instruments = c('Inst', 'Tabla'))
splicing_df <- splice_time(po1, window_duration = 1)
head(splicing_df)
}
\seealso{
Other splicing functions: 
\code{\link{clip_splice}()},
\code{\link{get_spliced_view}()},
\code{\link{is_splice_overlapping}()},
\code{\link{merge_splice}()},
\code{\link{splice_time.Duration}()},
\code{\link{splice_time.Metre}()},
\code{\link{splice_time.View}()},
\code{\link{splice_time.list}()},
\code{\link{splice_time}()},
\code{\link{split.SplicedView}()}
}
\concept{splicing functions}
