% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet.R
\name{get_local_max_average_power}
\alias{get_local_max_average_power}
\title{Get periods locally maximal average power}
\usage{
get_local_max_average_power(obj, v)
}
\arguments{
\item{obj}{\code{analyze.wavelet} object.}

\item{v}{\code{View} object.}
}
\value{
data.frame of Period and Local Maxima.
}
\description{
Get periods locally maximal average power
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
pv1 <- subset(pv, Time >= 10)
w <- analyze_wavelet(pv1, "Nose_x")
plot_average_power(w, pv1)
get_local_max_average_power(w, pv1)
}
\seealso{
Other wavelet functions: 
\code{\link{analyze_coherency}()},
\code{\link{analyze_wavelet}()},
\code{\link{plot_average_coherency}()},
\code{\link{plot_average_power}()},
\code{\link{plot_cross_spectrum}()},
\code{\link{plot_cwt_energy}()},
\code{\link{plot_phase_difference}()},
\code{\link{plot_power_spectrum}()},
\code{\link{plot_roll_resultant_length}()},
\code{\link{plot_sel_phases}()},
\code{\link{plot_wt_energy}()}
}
\concept{wavelet functions}
