% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bushfirem}
\alias{bushfirem}
\title{Bushfire scars with missing data.}
\format{
A data frame with 38 rows and 5 variables.
}
\usage{
bushfirem
}
\description{
The bushfire data set was used by Campbell (1984, 1989) to locate bushfire scars.
The dataset contains satellite measurements on five frequency bands, corresponding
to each of 38 pixels. However, this dataset contains missing values.
}
\details{
The data contains an outlying cluster of observations 33 to 38 a second outlier
cluster of observations 7 to 11 and a few more isolated outliers, namely observations
12, 13, 31 and 32.

\code{bushfirem} is created from bushfire by setting a proportion of 0.2 of the values
to missing.

For testing purposes weights are provided:
\code{bushfire.weights <- rep(c(1,2,5), length = nrow(bushfire))}
}
\examples{
data(bushfirem)
}
\references{
Campbell, N. (1989) Bushfire Mapping using NOAA AVHRR Data. Technical Report.
Commonwealth Scientific and Industrial Research Organisation, North Ryde.
}
\keyword{datasets}
