% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_fselect.R
\name{ensemble_fselect}
\alias{ensemble_fselect}
\title{Wrapper-based Ensemble Feature Selection}
\source{
Saeys, Yvan, Abeel, Thomas, Van De Peer, Yves (2008).
\dQuote{Robust feature selection using ensemble feature selection techniques.}
\emph{Machine Learning and Knowledge Discovery in Databases}, \bold{5212 LNAI}, 313--325.
\doi{10.1007/978-3-540-87481-2_21}.

Abeel, Thomas, Helleputte, Thibault, Van de Peer, Yves, Dupont, Pierre, Saeys, Yvan (2010).
\dQuote{Robust biomarker identification for cancer diagnosis with ensemble feature selection methods.}
\emph{Bioinformatics}, \bold{26}, 392--398.
ISSN 1367-4803, \doi{10.1093/BIOINFORMATICS/BTP630}.

Pes, Barbara (2020).
\dQuote{Ensemble feature selection for high-dimensional data: a stability analysis across multiple domains.}
\emph{Neural Computing and Applications}, \bold{32}(10), 5951--5973.
ISSN 14333058, \doi{10.1007/s00521-019-04082-3}.
}
\usage{
ensemble_fselect(
  fselector,
  task,
  learners,
  init_resampling,
  inner_resampling,
  inner_measure,
  measure,
  terminator,
  callbacks = NULL,
  store_benchmark_result = TRUE,
  store_models = FALSE
)
}
\arguments{
\item{fselector}{(\link{FSelector})\cr
Optimization algorithm.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learners}{(list of \link[mlr3:Learner]{mlr3::Learner})\cr
The learners to be used for feature selection.}

\item{init_resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
The initial resampling strategy of the data, from which each train set will be passed on to the \link{auto_fselector} to optimize the learners and perform feature selection.
Each test set will be used for prediction on the final models returned by \link{auto_fselector}.
Can only be \link[mlr3:mlr_resamplings_subsampling]{mlr3::ResamplingSubsampling} or \link[mlr3:mlr_resamplings_bootstrap]{mlr3::ResamplingBootstrap}.}

\item{inner_resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
The inner resampling strategy used by the \link{FSelector}.}

\item{inner_measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
The inner optimization measure used by the \link{FSelector}.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Measure used to score each trained learner on the test sets generated by \code{init_resampling}.}

\item{terminator}{(\link[bbotk:Terminator]{bbotk::Terminator})\cr
Stop criterion of the feature selection.}

\item{callbacks}{(Named list of lists of \link{CallbackBatchFSelect})\cr
Callbacks to be used for each learner.
The lists must be named by the learner ids.}

\item{store_benchmark_result}{(\code{logical(1)})\cr
Whether to store the benchmark result in \link{EnsembleFSResult} or not.}

\item{store_models}{(\code{logical(1)})\cr
Whether to store models in \link{auto_fselector} or not.}
}
\value{
an \link{EnsembleFSResult} object.
}
\description{
Ensemble feature selection using multiple learners.
The ensemble feature selection method is designed to identify the most predictive features from a given dataset by leveraging multiple machine learning models and resampling techniques.
Returns an \link{EnsembleFSResult}.
}
\details{
The method begins by applying an initial resampling technique specified by the user, to create \strong{multiple subsamples} from the original dataset (train/test splits).
This resampling process helps in generating diverse subsets of data for robust feature selection.

For each subsample (train set) generated in the previous step, the method performs \strong{wrapped-based feature selection} (\link{auto_fselector}) using each provided learner, the given inner resampling method, inner performance measure and optimization algorithm.
This process generates 1) the best feature subset and 2) a final trained model using these best features, for each combination of subsample and learner.
The final models are then scored on their ability to predict on the resampled test sets.

Results are stored in an \link{EnsembleFSResult}.

The result object also includes the performance scores calculated during the inner resampling of the training sets, using models with the best feature subsets.
These scores are stored in a column named \verb{\{measure_id\}_inner}.
}
\note{
The \strong{active measure} of performance is the one applied to the test sets.
This is preferred, as inner resampling scores on the training sets are likely to be overestimated when using the final models.
Users can change the active measure by using the \code{set_active_measure()} method of the \link{EnsembleFSResult}.
}
\examples{
\donttest{
  efsr = ensemble_fselect(
    fselector = fs("random_search"),
    task = tsk("sonar"),
    learners = lrns(c("classif.rpart", "classif.featureless")),
    init_resampling = rsmp("subsampling", repeats = 2),
    inner_resampling = rsmp("cv", folds = 3),
    inner_measure = msr("classif.ce"),
    measure = msr("classif.acc"),
    terminator = trm("evals", n_evals = 10)
  )
  efsr
}
}
