% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_var_1.R
\encoding{UTF-8}
\name{dis_var_1}
\alias{dis_var_1}
\title{Constructs a pairwise distance matrix based on the estimated VAR coefficients
of the series}
\usage{
dis_var_1(X, max_p = 1, criterion = "AIC", features = FALSE)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{max_p}{The maximum order considered with respect to the fitting of VAR models.}

\item{criterion}{The criterion used to determine the VAR order.}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{COR}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{VAR}}.
}
\description{
\code{dis_cor} returns a pairwise distance matrix based on a generalization of the
dissimilarity introduced by \insertCite{piccolo1990distance;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T} is defined
as
\deqn{d_{VAR}(\boldsymbol X_T, \boldsymbol Y_T)=||\widehat{\boldsymbol \theta}^{\boldsymbol X_T}_{VAR}-
\widehat{\boldsymbol \theta}^{\boldsymbol Y_T}_{VAR}||,}
where \eqn{\widehat{\boldsymbol \theta}^{\boldsymbol X_T}_{VAR}} and \eqn{\widehat{\boldsymbol \theta}^{\boldsymbol Y_T}_{VAR}} are vectors
containing the estimated VAR parameters for \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T}, respectively. If VAR models of
different orders are fitted to \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T}, then the shortest
vector is padded with zeros until it reaches the length of the longest vector.
}
\examples{
toy_dataset <- Libras$data[1 : 2] # Selecting the first 2 MTS from the
# dataset Libras
distance_matrix <- dis_var_1(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_var_1
feature_dataset <- dis_var_1(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{piccolo1990distance}{mlmts}

}
}
\seealso{
\code{\link{dis_var_2}}, \code{\link[TSclust]{diss.AR.PIC}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
