% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.omit.R
\name{chr.omit}
\alias{chr.omit}
\title{Omit Strings}
\usage{
chr.omit(x, omit = "", na.omit = FALSE, check = TRUE)
}
\arguments{
\item{x}{a numeric vector, character vector or factor.}

\item{omit}{a numeric vector or character vector indicating values or
strings to be omitted
from the vector \code{x}, the default setting is the empty
strings \code{""}.}

\item{na.omit}{logical: if \code{TRUE}, missing values (\code{NA}) are also
omitted from the vector.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns a numeric vector, character vector or factor with values or strings
specified in \code{omit} omitted from the vector specified in \code{x}.
}
\description{
This function omits user-specified values or strings from a numeric vector,
character vector or factor.
}
\examples{
#-------------------------------------------------------------------------------
# Charater vector
x.chr <- c("a", "", "c", NA, "", "d", "e", NA)

# Example 1: Omit character string ""
chr.omit(x.chr)

# Example 2: Omit character string "" and missing values (NA)
chr.omit(x.chr, na.omit = TRUE)

# Example 3: Omit character string "c" and "e"
chr.omit(x.chr, omit = c("c", "e"))

# Example 4: Omit character string "c", "e", and missing values (NA)
chr.omit(x.chr, omit = c("c", "e"), na.omit = TRUE)

#-------------------------------------------------------------------------------
# Numeric vector
x.num <- c(1, 2, NA, 3, 4, 5, NA)

# Example 5: Omit values 2 and 4
chr.omit(x.num, omit = c(2, 4))

# Example 6: Omit values 2, 4, and missing values (NA)
chr.omit(x.num, omit = c(2, 4), na.omit = TRUE)

#-------------------------------------------------------------------------------
# Factor
x.factor <- factor(letters[1:10])

# Example 7: Omit factor levels "a", "c", "e", and "g"
chr.omit(x.factor, omit = c("a", "c", "e", "g"))
}
\seealso{
\code{\link{chr.color}}, \code{\link{chr.grep}}, \code{\link{chr.grepl}},
\code{\link{chr.gsub}}, \code{\link{chr.trim}}, \code{\link{chr.trunc}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
