% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniq.R
\name{uniq}
\alias{uniq}
\alias{uniq.n}
\title{Extract Unique Elements and Count Number of Unique Elements}
\usage{
uniq(data, ..., na.rm = TRUE, sort = TRUE, decreasing = FALSE, digits = NULL,
     table = TRUE, check = TRUE )

uniq.n(data, ..., na.rm = TRUE, digits = NULL, check = TRUE)
}
\arguments{
\item{data}{a vector, factor, matrix, or data frame.}

\item{...}{an expression indicating the variable names in \code{data},
e.g., \code{uniq(dat, x1, x2)} for selecting the variables
\code{x1} and \code{x2} from the data frame \code{dat}. Note
that the operators \code{.}, \code{+}, \code{-}, \code{~},
\code{:}, \code{::}, and \code{!} can also be used to select
variables, see 'Details' in the \code{\link{df.subset}} function.}

\item{na.rm}{logical: if \code{TRUE} (default), missing values are omitted
before extracting unique elements.}

\item{sort}{logical: if \code{TRUE} (default), unique elements are sorted
after.}

\item{decreasing}{logical: if \code{TRUE}, unique elements are sorted decreasing.}

\item{digits}{an integer value indicating the number of decimal places to
be used when rounding numeric values before extracting unique
elements. By default, unique elements are extracted without
rounding, i.e., \code{digits = NULL}.}

\item{table}{logical: if \code{TRUE} (default), unique elements are printed
in a data frame, if \code{FALSE} unique elements are printed
in a list.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}
}
\value{
Returns a vector, factor, data frame, or list.
}
\description{
The function \code{uniq} returns a vector or data frame with duplicated elements
removed. By default, missing values are omitted and unique elements are sorted
increasing. The function \code{uniq.n} counts the number of unique elements
in a vector or for each column in a matrix or data frame. By default, missing
values are omitted before counting the number of unique elements.
}
\details{
The function \code{uniq} is a wrapper function in the form of \code{sort(unique(na.omit(x)))},
while the function \code{uniq.n} is a wrapper function in the form of \code{length(unique(na.omit(x)))}.
}
\examples{
#----------------------------------------------------------------------------
# Extract Unique Elements, uniq() function

# Example 1a: Extract unique elements in a vector
uniq(airquality, Ozone)

# Example 1b: Extract unique elements in a vector, round elements
uniq(airquality, Wind, digits = 0)

# Example 1b: Extract unique elements in a vector, do not sort
uniq(airquality, Ozone, sort = FALSE)

# Example 1b: Extract unique elements in a vector, keep NA
uniq(airquality, Ozone, na.rm = FALSE)

# Example 2a: Extract unique elements in a data frame
uniq(airquality)

# Example 2a: Extract unique elements in list
uniq(airquality, table = FALSE)

#----------------------------------------------------------------------------
# Count Number of Unique Elements, uniq.n() function

# Example 3a: Count number of unique elements in a vector
uniq.n(airquality, Ozone)

# Example 1b: Count number of unique elements for each variable in a data frame
uniq.n(airquality)
}
\references{
Becker, R. A., Chambers, J. M., & Wilks, A. R. (1988). \emph{The New S Language}.
Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{df.duplicated}}, \code{\link{df.unique}}
}
\author{
Takuya Yanagida
}
