% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misclassMLogit.R
\name{misclassMlogit}
\alias{misclassMlogit}
\title{Mlogit estimation under misclassified covariate}
\usage{
misclassMlogit(
  Y,
  X,
  setM,
  P,
  na.action = na.omit,
  control = list(),
  par = NULL,
  baseoutcome = NULL,
  x = FALSE
)
}
\arguments{
\item{Y}{a matrix of 0s and 1s, indicating the target class. This is the dependent variable.}

\item{X}{a matrix containing the independent variables}

\item{setM}{matrix, rows containing potential patterns for a misclassed (latent) covariate M in
any coding for a categorical independent variable, e.g. dummy coding.}

\item{P}{probabilities corresponding to each of the potential pattern conditional on the other
covariates denoted in x.}

\item{na.action}{how to treat NAs}

\item{control}{options for the optimization procedure (see \code{\link{optim}},
\code{\link{ucminf}} for options and details).}

\item{par}{(optional) starting parameter vector}

\item{baseoutcome}{reference outcome class}

\item{x}{logical, add covariates matrix to result?}
}
\description{
\code{misclassMLogit} computes estimator for a GLM with a misclassified covariate
using additional side information on the misclassification process
}
\examples{
## simulate data
\donttest{
data <- simulate_mlogit_dataset()
}

## estimate model without misclassification error
\donttest{
library(mlogit)
data2 <- mlogit.data(data, varying = NULL, choice = "Y", shape = "wide")
summary(mlogit(Y ~ 1 | X + M2, data2, reflevel = "3"))
}

## estimate model with misclassification error
\donttest{
summary(mlogit(Y ~ 1 | X + M, data2, reflevel = "3"))
}

## estimate misclassification probabilities
\donttest{
Pmodel <- glm(M2 ~ M + X, data = data, family = binomial("logit"))
summary(Pmodel)
}

## construct a-posteriori probabilities from Pmodel
\donttest{
P <- predict(Pmodel, newdata = data, type = "response")
P <- cbind(1 - P, P)
dimnames(P)[[2]] <- c("M0", "M1") ## speaking names
}

## estimate misclassGLM
\donttest{
Yneu <- matrix(rep.int(0, nrow(data) * 3), ncol = 3)
for (i in 1:nrow(data)) Yneu[i, data$Y[i]] <- 1
est <- misclassMlogit(Y = Yneu,
                      X = as.matrix(data[, 2, drop = FALSE]),
                      setM = matrix(c(0, 1), nrow = 2),
                      P = P)
summary(est)
}

## and bootstrapping the results from dataset
\dontrun{
summary(boot.misclassMlogit(est,
                         Y = Yneu,
                         X = data.matrix(data[, 2, drop = FALSE]),
                         Pmodel = Pmodel,
                         PX = data,
                         repetitions = 100))
}

}
