% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda_miretrieve.R
\name{fit_lda}
\alias{fit_lda}
\title{Fit LDA-model}
\usage{
fit_lda(
  df,
  k,
  stopwords = stopwords_miretrieve,
  method = "gibbs",
  control = NULL,
  seed = 42,
  col.abstract = Abstract,
  col.pmid = PMID
)
}
\arguments{
\item{df}{Data frame containing abstracts and PubMed-IDs.}

\item{k}{Integer. Number of topics to fit. Must be >=2.}

\item{stopwords}{Data frame containing stop words.}

\item{method}{String. Either \code{"gibbs"} or \code{"VEM"}.}

\item{control}{Control parameters for LDA modeling. For more information,
see the documentation of the \code{LDAcontrol} class in the \pkg{topicmodels}
package.}

\item{seed}{Integer. Seed for reproducibility.}

\item{col.abstract}{Column containing abstracts.}

\item{col.pmid}{Column containing PubMed-ID.}
}
\value{
LDA-model.
}
\description{
Fit LDA-model with \code{k} topics.
}
\details{
Fit LDA-model with \code{k} topics from a data frame.
\code{fit_lda()} is based on \code{LDA()} from the package
\pkg{topicmodels}.
}
\seealso{
\code{\link[=plot_perplexity]{plot_perplexity()}}

Other LDA functions: 
\code{\link{assign_topic_lda}()},
\code{\link{plot_lda_term}()},
\code{\link{plot_perplexity}()}
}
\concept{LDA functions}
