% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_quota_from}
\alias{get_quota_from}
\title{Get api quota info}
\usage{
get_quota_from(service = c("meteocat"), options)
}
\arguments{
\item{service}{Character with the service name (in lower case).}

\item{options}{List with the needed service options. See \code{\link{services_options}} to have more info
about the different services and their options.}
}
\value{
A data frame with the quota info
}
\description{
Obtain info about the API quota used
}
\details{
Depending on the service, some APIs allows only a number of data requests. This function access the user
quota numbers in the services that allow for this, \strong{(currently only MeteoCat)}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  library(meteospain)
  library(keyring)

  # MeteoCat (we need a key)
  # key_set('meteocat')
  api_options <- meteocat_options(api_key = key_get('meteocat'))
  get_quota_from('meteocat', api_options)
\dontshow{\}) # examplesIf}
}
