% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarImpPlot.R
\name{VarImpPlot}
\alias{VarImpPlot}
\title{Plots variable importance for a MetaForest object.}
\usage{
VarImpPlot(mf, n.var = 30, sort = TRUE, ...)
}
\arguments{
\item{mf}{MetaForest object.}

\item{n.var}{Number of moderators to plot.}

\item{sort}{Should the moderators be sorted from most to least important?}

\item{...}{Parameters passed to and from other functions.}
}
\value{
A ggplot object.
}
\description{
Plots variable importance for a MetaForest object.
}
\examples{
set.seed(42)
data <- SimulateSMD()
mf.random <- MetaForest(formula = yi ~ ., data = data$training,
                        whichweights = "random", method = "DL",
                        tau2 = 0.0116)
VarImpPlot(mf.random)
VarImpPlot(mf.random, n.var = 2)
VarImpPlot(mf.random, sort = FALSE)
}
