% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runExperiment.R
\name{runExperiment}
\alias{runExperiment}
\title{Computes ecological memory patterns on simulated pollen curves produced by the \code{virtualPollen} library.}
\usage{
runExperiment(
 simulations.file = NULL,
 selected.rows = 1,
 selected.columns = 1,
 parameters.file = NULL,
 parameters.names = NULL,
 sampling.names = NULL,
 driver.column = NULL,
 response.column = "Response_0",
 subset.response = "none",
 time.column = "Time",
 time.zoom = NULL,
 lags = NULL,
 repetitions = 10
 )
}
\arguments{
\item{simulations.file}{list of dataframes, output of  the function \code{simulatePopulation} of the \code{virtualPollen} library.}

\item{selected.rows}{numeric vector, rows (virtual taxa) of \code{simulations.file} to be analyzed.}

\item{selected.columns}{numeric.vector, columns (experiment treatments) of \code{simulations.file} to be analyzed.}

\item{parameters.file}{dataframe of simulation parameters.}

\item{parameters.names}{vector of character strings with names of traits and niche features from \code{parameters.file} to be included in the analysis (i.e. c("maximum.age", "fecundity", "niche.A.mean", "niche.A.sd"))}

\item{sampling.names}{vector of character strings with the names of the columns of \code{simulations.file}.}

\item{driver.column}{vector of character strings, names of the columns to be considered as drivers (generally, one of "Suitability", "Driver.A", "Driver.B).}

\item{response.column}{character string defining the response variable, typically "Response_0".}

\item{subset.response}{character string, one of "up", "down" or "none", triggers the subsetting of the input dataset. "up" only models ecological memory on cases where the response's trend is positive, "down" selectes cases with negative trends, and "none" selects all cases.}

\item{time.column}{character string, name of the time/age column. Usually, "Time".}

\item{time.zoom}{numeric vector with two numbers defining the time/age extremes of the time interval of interest.}

\item{lags}{ags numeric vector of positive integers, lags to be used in the equation. Generally, a regular sequence of numbers, in the same units as \code{time}. The use \code{\link{seq}} to define it is highly recommended. If 0 is absent from lags, it is added automatically to allow the consideration of a concurrent effect. Lags should take into account the temporal resolution of the data, and be aligned to it. For example, if the interval between consecutive samples is 100 years, lags should be something like \code{0, 100, 200, 300}. Lags can also be multiples of the time resolution, such as \code{0, 200, 400, 600} (in the case time resolution is 100 years).}

\item{repetitions}{integer, number of random forest models to fit.}
}
\value{
A list with 2 slots:
 \itemize{
 \item \code{names} matrix of character strings, with as many rows and columns as \code{simulations.file}. Each cell holds a simulation name to be used afterwards, when plotting the results of the ecological memory analysis.
 \item \code{output} a list with as many columns and columns as \code{simulations.file}. Each slot holds a an output of \code{\link{computeMemory}}.
 \itemize{
 \item \code{memory} dataframe with five columns:
    \itemize{
      \item \code{Variable} character, names and lags of the different variables used to model ecological memory.
      \item \code{median} numeric, median importance across \code{repetitions} of the given \code{Variable} according to Random Forest.
      \item \code{sd} numeric, standard deviation of the importance values of the given \code{Variable} across \code{repetitions}.
      \item \code{min} and \code{max} numeric, percentiles 0.05 and 0.95 of importance values of the given \code{Variable} across \code{repetitions}.
    }
 \item \code{R2} vector, values of pseudo R-squared value obtained for the Random Forest model fitted on each repetition. Pseudo R-squared is the Pearson correlation beteween the observed and predicted data.
 \item \code{prediction} dataframe, with the same columns as the dataframe in the slot \code{memory}, with the median and confidence intervals of the predictions of all random forest models fitted.
 \item \code{multicollinearity} multicollinearity analysis on the input data performed with \code{\link[HH]{vif}}. A vif value higher than 5 indicates that the given variable is highly correlated with other variables.
}
}
}
\description{
Applies \code{\link{computeMemory}} to assess ecological memory on a large set of virtual pollen curves.
}
\seealso{
\code{\link{computeMemory}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
