#' Capital cities for each country
#'
#' A data set containing the coordinates of 200 capitical cities in the world
#'
#' @format A data frame with 200 observations and 4 variables
#' \describe{
#'   \item{country}{country name}
#'   \item{capital}{capital name}
#'   \item{lat}{latitude of capital}
#'   \item{lon}{longitude of capital}
#' }
"capitals"

#' Roads in central Melbourne
#'
#' A simple feature \code{sf} object of roads in central Melbourne
#'
#' @details
#' Obtained from \url{https://www.data.gov.au} and distributed under the Creative Commons 4 License
#' \url{https://creativecommons.org/licenses/by/4.0/}
#'
#' @format An sf and data frame object with 18286 observations and 16 variables
#'
"roads"

#' Polygons in and around Melbourne
#'
#' A data set containing statistical area 2 regions of central (and surrounds) Melbourne.
#'
#' @format An sfencoded and data frame object with 41 observations and 8 variables.
#' See library googlePolylines for information on sfencoded objects
"melbourne"

#' Geojson
#'
#' A GeoJSON object of polygons, lines and points in Melbourne
#'
#' @format a 'json' object
"geojson"

#' Melbourne Mesh
#'
#' A mesh3d object of Melbourne
#'
"melbourne_mesh"

#' city_trail
#'
#' An sf object of a cyclist cycling around Melbourne's Capital City Trail
#'
"city_trail"

#' road_safety
#'
#' A data.frame of counts of traffic accidents in the UK
"road_safety"
