% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks-monitor-metrics.R
\name{luz_callback_model_checkpoint}
\alias{luz_callback_model_checkpoint}
\title{Checkpoints model weights}
\usage{
luz_callback_model_checkpoint(
  path,
  monitor = "valid_loss",
  save_best_only = FALSE,
  mode = "min",
  min_delta = 0
)
}
\arguments{
\item{path}{Path to save the model on disk. The path is interpolated with \code{glue},
so you can use any attribute within the \link{ctx} by using \code{'{ctx$epoch}'}. Specially
the \code{epoch} and \code{monitor} quantities are already in the environment. If the specified
path is a path to a directory (ends with \code{/} or \verb{\\}), then models are saved with the name given by
\verb{epoch-\{epoch:02d\}-\{self$monitor\}-\{monitor:.3f\}.pt}. See more in the examples.
You can use \code{\link[=sprintf]{sprintf()}} to quickly format quantities, for example:\code{'{epoch:02d}'}.}

\item{monitor}{A string in the format \verb{<set>_<metric>} where \verb{<set>} can be
'train' or 'valid' and \verb{<metric>} can be the abbreviation of any metric
that you are tracking during training. The metric name is case insensitive.}

\item{save_best_only}{if \code{TRUE} models are only saved if they have an improvement
over a previously saved model.}

\item{mode}{Specifies the direction that is considered an improvement. By default
'min' is used. Can also be 'max' (higher is better) and 'zero'
(closer to zero is better).}

\item{min_delta}{Minimum difference to consider as improvement. Only used when
\code{save_best_only=TRUE}.}
}
\description{
This saves checkpoints of the model according to the specified metric and
behavior.
}
\note{
\code{mode} and \code{min_delta} are only used when \code{save_best_only=TRUE}.
\code{save_best_only} will overwrite the saved models if the \code{path} parameter
don't differentiate by epochs.

Read the checkpointing article in the pkgdown website for more
information.
}
\examples{
luz_callback_model_checkpoint(path= "path/to/dir")
luz_callback_model_checkpoint(path= "path/to/dir/epoch-{epoch:02d}/model.pt")
luz_callback_model_checkpoint(path= "path/to/dir/epoch-{epoch:02d}/model-{monitor:.2f}.pt")

}
\seealso{
Other luz_callbacks: 
\code{\link{luz_callback}()},
\code{\link{luz_callback_auto_resume}()},
\code{\link{luz_callback_csv_logger}()},
\code{\link{luz_callback_early_stopping}()},
\code{\link{luz_callback_interrupt}()},
\code{\link{luz_callback_keep_best_model}()},
\code{\link{luz_callback_lr_scheduler}()},
\code{\link{luz_callback_metrics}()},
\code{\link{luz_callback_mixed_precision}()},
\code{\link{luz_callback_mixup}()},
\code{\link{luz_callback_profile}()},
\code{\link{luz_callback_progress}()},
\code{\link{luz_callback_resume_from_checkpoint}()},
\code{\link{luz_callback_train_valid}()}
}
\concept{luz_callbacks}
