% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spca_rsvd.R
\name{sPCA_rSVD}
\alias{sPCA_rSVD}
\title{Sparse Principal Component Analysis via Regularized Singular Value Decompsition (sPCA-rSVD)}
\usage{
sPCA_rSVD(x, k, method = "hard", center = FALSE, scale = FALSE,
  l.search = NULL, ls.min = 1)
}
\arguments{
\item{x}{the input data matrix}

\item{k}{the maximal number of PC's to seach for in the initial stage}

\item{method}{threshold method used in the algorithm; If \code{method = "hard"} (defauls), the hard threshold function is used;
if \code{method = "soft"}, the soft threshold function is used; if \code{method = "scad"}, the scad threshold function is used}

\item{center}{if \code{center = TRUE} the data will be centered by the columnwise means; default is \code{center = FALSE}}

\item{scale}{if \code{scale = TRUE} the data will be scaled by the columnwise standard deviations; default is \code{scaled = FALSE}}

\item{l.search}{a list of length kmax which contains the search grids chosen by the user; default is NULL}

\item{ls.min}{the smallest grid step when searching for the sparsity of each PC; default is 1}
}
\value{
an object of class "sPCA_rSVD" is returned \cr
\item{loadings}{the sparse loading matrix estimated with sPCA_rSVD}
\item{scores}{the estimated score matrix}
\item{eigenvalues}{the estimated eigenvalues}
\item{spca.it}{the list that contains the results of sPCA_rSVD when searching for the individual PCs}
\item{ls}{the list that contains the final search grid for each PC direction}
}
\description{
the function that computes sPCA_rSVD
}
\examples{
\dontrun{
nonrobM <- sPCA_rSVD(x = x, k = 2, center =  T, scale = F)
}
}
\references{
Shen, H. and Huang, J. (2008), ``Sparse principal component anlysis via regularized low rank matrix decomposition'', \emph{Journal of Multivariate Analysis}, 99, 1015--1034.

Shen, D., Shen, H., and Marron, J. (2013). ``Consistency of sparse PCA in high dimensional low sample size context'', \emph{Journal of Multivariate Analysis}, 115, 315--333.
}
