% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.lcc}
\alias{coef.lcc}
\title{Extract Model Coefficients}
\usage{
\method{coef}{lcc}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{lcc},
representing a fitted longitudinal concordance correlation
function.}

\item{...}{optional arguments passed to the \code{coef.lme}
function.}
}
\value{
Coefficients extracted from the model object.
}
\description{
The fixed effects estimated and corresponding random
  effects estimates are obtained at subject levels less or equal to
  i. The resulting estimates are returned as a data frame, with rows
  corresponding to subject levels and columns to coefficients.
}
\details{
See methods for \code{\link{nlme}} objects to get more
  details.
}
\examples{

\dontrun{
fm1<-lcc(data = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
coef(fm1)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{summary.lcc}},
  \code{\link{lccPlot}}, \code{\link{vcov.lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
