% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{jellyfisher-shiny}
\alias{jellyfisher-shiny}
\alias{jellyfisherOutput}
\alias{renderJellyfisher}
\title{Shiny bindings for jellyfisher}
\usage{
jellyfisherOutput(outputId, width = "100\%", height = "400px")

renderJellyfisher(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a jellyfisher}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
\describe{
\item{\code{jellyfisherOutput()}}{
A \code{shiny.tag} object that can be included in a Shiny UI definition.}
\item{\code{renderJellyfisher()}}{
A \code{shiny.render.function} that returns an \code{htmlwidget} object for use in
a Shiny server function.}
}
}
\description{
Output and render functions for using jellyfisher within Shiny
applications and interactive Rmd documents.
}
