% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimals.R
\name{formatPercentage}
\alias{formatPercentage}
\title{Format a percentage.}
\usage{
formatPercentage(x, nDec = 1)
}
\arguments{
\item{x}{Numeric vector with percentage(s)}

\item{nDec}{Integer of length 1, number
of decimals used to round the percentage,
1 by default.}
}
\value{
String with formatted percentage
}
\description{
The following rules are used:
\itemize{
\item{percentage = 0\%: '0'}
\item{ 0\% < percentage < 0.1\%: '<0.1'}
\item{99.9\% < percentage < 100\%: '>99.9'}
\item{percentage = 100\%: '100'}
\item{missing value (NA) (class without valid data): '-'}
\item{other: 'x.x' (1 decimal)}
}
}
\examples{
xPerc <- c(NA, 0, 100, 99.95, 0.012, 34.768)
formatPercentage(x = xPerc)
}
\seealso{
Other decimals: 
\code{\link{getMaxNDecimals}()},
\code{\link{getMaxNDecimalsData}()},
\code{\link{getNDecimals}()},
\code{\link{getNDecimalsData}()}
}
\author{
Laure Cougnaud
}
\concept{decimals}
