% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_index.R
\name{hexify_lonlat_to_index}
\alias{hexify_lonlat_to_index}
\title{Convert longitude/latitude to index string}
\usage{
hexify_lonlat_to_index(
  lon,
  lat,
  resolution,
  aperture = 3L,
  index_type = c("auto", "z3", "z7", "zorder")
)
}
\arguments{
\item{lon}{Longitude in degrees}

\item{lat}{Latitude in degrees}

\item{resolution}{Resolution level}

\item{aperture}{Aperture (3, 4, or 7)}

\item{index_type}{Index encoding: "auto" (default), "z3", "z7", or "zorder"}
}
\value{
Index string
}
\description{
Main entry point for geocoding points to grid cells.
}
\examples{
idx <- hexify_lonlat_to_index(16.37, 48.21, resolution = 5, aperture = 3)
}
\seealso{
Other hierarchical index: 
\code{\link{hexify_cell_to_index}()},
\code{\link{hexify_compare_indices}()},
\code{\link{hexify_default_index_type}()},
\code{\link{hexify_get_children}()},
\code{\link{hexify_get_parent}()},
\code{\link{hexify_get_resolution}()},
\code{\link{hexify_index_to_cell}()},
\code{\link{hexify_index_to_lonlat}()},
\code{\link{hexify_is_valid_index_type}()},
\code{\link{hexify_z7_canonical}()}
}
\concept{hierarchical index}
\keyword{internal}
