% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hesim_data.R
\name{time_intervals}
\alias{time_intervals}
\title{Time intervals}
\usage{
time_intervals(times)
}
\arguments{
\item{times}{Either a vector of starting times for each interval or a
\code{data.frame} with at least one column named \code{time_start}.}
}
\value{
An object of class \code{time_intervals} that inherits from
\code{data.table} in the same format as \code{time_intervals} as
described in \link{id_attributes}.
}
\description{
Create a table of time intervals given a vector or data frame of unique times.
This would typically be passed to \link{id_attributes}.
}
\examples{
time_intervals(c(0, 3, 5))
time_intervals(data.frame(time_start = c(0, 3, 5),
                          time_cat = c("Time <= 3", "3 < Time <= 5", 
                                       "Time > 5")))
}
\seealso{
\link{id_attributes}
}
