% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_worth.R
\name{pairwise_probs}
\alias{pairwise_probs}
\title{Compute pairwise probabilities}
\usage{
pairwise_probs(object, relative.probs = TRUE, ...)
}
\arguments{
\item{object}{a named numeric vector with probabilities}

\item{relative.probs}{logical, TRUE to return matrix with relative
probs (prob - 0.5), otherwise true values are returned}

\item{...}{additional arguments passed to methods}
}
\value{
a matrix with pairwise probabilities
}
\description{
Implements the Luce's Choice Axiom to calculate pairwise probabilities 
in a set of choice probabilities. The Luce's Choice Axiom states
that the probability of selecting one item over another from a pool of
many items is not affected by the presence or absence of other items
in the pool.
}
\examples{

library("PlackettLuce")
library("ggplot2")

R = matrix(c(1, 2, 3, 0,
             4, 1, 2, 3,
             2, 1, 3, 4,
             1, 2, 3, 0,
             2, 1, 3, 0,
             1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) = c("apple", "banana", "grape", "pear")

mod = PlackettLuce(R)

coefs = coefficients(mod, log = FALSE)

pair_worth = pairwise_probs(coefs)

pair_worth

# plot the results
lvls = dimnames(pair_worth)[[1]]

pair_dat = data.frame(player1 = rep(lvls, times = length(lvls)), 
                      player2 = rep(lvls, each = length(lvls)),
                      worth = as.vector(pair_worth))

pair_dat

pair_dat$player1 = factor(pair_dat$player1, levels = lvls)

pair_dat$player2 = factor(pair_dat$player2, levels = rev(lvls))

pair_dat$worth = round(pair_dat$worth, 2)

ggplot(pair_dat, 
       aes(x = player2, 
           y = player1,
           fill = worth,
           label = worth)) +
  geom_tile(show.legend = FALSE) + 
  geom_text() +
  scale_fill_gradient2(low = "#b2182b", 
                       high = "#2166ac", 
                       na.value = "white") +
  scale_x_discrete(position = "top") +
  theme_bw() +
  theme(axis.text = element_text(color = "grey10"),
        strip.text.x = element_text(color = "grey10"),
        axis.text.x = element_text(angle = 90, hjust = 0),
        panel.grid = element_blank()) +
  labs(x = "", 
       y = "",
       fill = "")

}
