% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstatCompatibility.R
\name{variogramModelPlot.gstatVariogram}
\alias{variogramModelPlot.gstatVariogram}
\title{Quick plotting of empirical and theoretical variograms
Quick and dirty plotting of empirical variograms/covariances with or without their models}
\usage{
\method{variogramModelPlot}{gstatVariogram}(
  vg,
  model = NULL,
  col = rev(rainbow(1 + length(unique(vg$dir.hor)))),
  commonAxis = FALSE,
  newfig = TRUE,
  closeplot = TRUE,
  ...
)
}
\arguments{
\item{vg}{empirical variogram or covariance function}

\item{model}{optional, theoretical variogram or covariance function}

\item{col}{colors to use for the several directional variograms}

\item{commonAxis}{boolean, should all plots in a row share the same vertical axis?}

\item{newfig}{boolean, should a new figure be created? otherwise user should ensure the device space is appropriately managed}

\item{closeplot}{logical, should the plot be left open (FALSE) for further changes, or be frozen (TRUE)?
defaults to TRUE}

\item{...}{further parameters to underlying plot or matplot functions}
}
\value{
The function is primarily called for producing a plot. However, it
invisibly returns the graphical parameters active before the call
occurred. This is useful for constructing complex diagrams, by giving
argument \code{closeplot=FALSE} and then adding layers
of information. If you want to "freeze" your plot, either give \code{closeplot=TRUE} or
embed your call in another call to \code{\link{par}}, e.g. \code{par(variogramModelPlot(...))}.
}
\description{
Quick plotting of empirical and theoretical variograms
Quick and dirty plotting of empirical variograms/covariances with or without their models
}
\examples{
data("jura", package="gstat")
X = jura.pred[,1:2]
Zc = jura.pred[,7:13]
gg = make.gmCompositionalGaussianSpatialModel(Zc, X, V="alr", formula = ~1)
vg = variogram(gg)
md = gstat::vgm(model="Sph", psill=1, nugget=1, range=1.5)
gg = fit_lmc(v=vg, g=gg, model=md)
variogramModelPlot(vg, model=gg)
}
\seealso{
\code{gstat::plot.gstatVariogram()}

Other variogramModelPlot: 
\code{\link{variogramModelPlot.logratioVariogram}()},
\code{\link{variogramModelPlot}()}
}
\concept{variogramModelPlot}
