% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmAnisotropy.R
\name{anis_GSLIBpar2A}
\alias{anis_GSLIBpar2A}
\alias{anis2D_par2A}
\alias{anis3D_par2A}
\title{Produce anisotropy scaling matrix from angle and anisotropy ratios}
\usage{
anis_GSLIBpar2A(ratios, angles, inv = FALSE)

anis2D_par2A(ratio, angle, inv = FALSE)

anis3D_par2A(ratios, angles, inv = FALSE)
}
\arguments{
\item{ratios}{vector of two values between 0 and 1 giving the anisotropy ratios of
medium/largest smallest/largest ranges}

\item{angles}{as defined in gstat::vgm (and indeed GSLIB). For \code{anis2D_par2A} 'angle' is the direction of maximum range, i.e. largest spatial continuity, measured clockwise from North}

\item{inv}{boolean or integer, see \code{return} for details}

\item{ratio}{an anisotropy ratio (min/max range)}

\item{angle}{direction of maximum range, i.e. largest spatial continuity, measured
clockwise from North}
}
\value{
a 3x3 matrix of anisotropy.

If \code{inv=TRUE} (or 1) the output is a matrix \code{A} such that \code{norm(h \%*\% A)}
allows to use isotropic variograms, being \code{h = c(hx, hy, hz)} the lag vectors.

If \code{inv=FALSE} (or 0) the output is a matrix \code{A} such that \code{norm(h \%*\% solve(A))}
allows to use isotropic variograms.

Other values are meaningless.
}
\description{
Produce anisotropy matrix (as the transposed of the Cholesky
decomposition) from angle and anisotropy ratios
}
\section{Functions}{
\itemize{
\item \code{anis2D_par2A}: 2D case

\item \code{anis3D_par2A}: 3D case
}}

\examples{
## ratio=0.5, azimuth 30?? (i.e. direction 60??)
A = anis2D_par2A(1, 30)
A
AAt = A \%*\% t(A)
 #  project the bisector 1:1 (i.e. 45??)
(k = c(1,1,0) \%*\% A)
atan2(k[2], k[1]) * 180/pi  # should be 15
sqrt(sum(k^2))
sqrt( c(1,1,0) \%*\% AAt \%*\% c(1,1,0) )
A = anis2D_par2A(0.5, 60)
rd = 60 * pi/180
A
A \%*\% t(A)
c(cos(rd), sin(rd),0) \%*\% A #  should be 1
c(-sin(rd), cos(rd),0) \%*\% A #  should be +/- sqrt(2)
c60 = cos(60*pi/180)
s60 = sin(60*pi/180)
c30 = cos(30*pi/180)
s30 = sin(30*pi/180)
#  in the new coordinates, 60cwN is (0,1,0)
R60p = anis3D_par2A(ratios=c(1,1), angles=c(60,0,0))
c(s60, c60, 0) \%*\% R60p
R6030 = anis3D_par2A(ratios=c(1,1), angles=c(60,30,0))
# the original X axis is positive on newX and newY, but negative on newZ
c(1,0,0) \%*\% R6030
# rotate first direction 60 degrees azimuth, then dip 30degrees upwards
c( c60*c30, -s60*c30, s30) \%*\% R6030
(Ranis = anis3D_par2A(ratios=c(0.5,0.25), angles=c(60,30,0)) )
}
\seealso{
Other anisotropy: 
\code{\link{AnisotropyRangeMatrix}()},
\code{\link{AnisotropyScaling}()},
\code{\link{as.AnisotropyRangeMatrix}()},
\code{\link{as.AnisotropyScaling}()},
\code{\link{is.anisotropySpecification}()}
}
\concept{anisotropy}
