% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anamorphosis.R
\name{anaBackward}
\alias{anaBackward}
\title{Backward gaussian anamorphosis
backward transformation to multivariate gaussian scores}
\usage{
anaBackward(
  x,
  Y,
  sigma0,
  sigma1 = 1 + sigma0,
  steps = 30,
  plt = FALSE,
  sphere = TRUE,
  weights = NULL
)
}
\arguments{
\item{x}{matrix of gaussian scores to be back-transformed}

\item{Y}{node points defining the transformation (a matrix, same nr of columns)}

\item{sigma0}{starting spread of the kernels in the forward transform}

\item{sigma1}{final spread of the kernels in the forward transform}

\item{steps}{number of steps to linearize the transform (default 30 is good)}

\item{plt}{boolean, do you want to get a plot of the transformation?}

\item{sphere}{boolean, should the data be taken as pre-Y-spherified? defaults to true}

\item{weights}{vector of weights for all computations, length must be equal
to number of rows of \code{x}}
}
\value{
a matrix with the scores back-transformed to the same scale as \code{Y}; same dimensions of \code{x}
}
\description{
Backward gaussian anamorphosis
backward transformation to multivariate gaussian scores
}
\examples{
data("jura", package="gstat")
Y = jura.pred[,c(10,12,13)]
plot(compositions::acomp(Y))
Ylr = compositions::alr(Y)
Xns = matrix(rnorm(500), ncol=2)
plot(Ylr)
points(Xns, col=2, pch=4)
Xlr = anaBackward(x=Xns, Y=Ylr, sigma0=0.1)
qqplot(Xlr[,1], Ylr[,1])
qqplot(Xlr[,2], Ylr[,2])
qqplot(Xlr[,1]+Xlr[,2], Ylr[,1]+Ylr[,2])
}
\seealso{
\code{\link[=ana]{ana()}} for defining a function that carries over the transformation
(by means of a closure), \code{\link[=anaBackward]{anaBackward()}} for the explicit back-transformation,
\code{\link[=sphTrans]{sphTrans()}} for defining a function that carries over the spherification of the data
}
\author{
K. Gerald van den Boogaart, Raimon Tolosana-Delgado
}
