% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtranslate.R
\name{ggtranslate}
\alias{ggtranslate}
\title{Translate all text elements in a ggplot2 object}
\usage{
ggtranslate(plot, dictionary_list)
}
\arguments{
\item{plot}{A ggplot object whose text elements are to be translated.}

\item{dictionary_list}{A named list (or named character vector) where the names are the original text and the values are the translated text.}
}
\value{
A modified ggplot object with all translatable text elements replaced
  according to the provided dictionary list.
}
\description{
This function takes a ggplot2 object and a named list to translate
all user-facing text elements within the plot. This includes main plot labels
(title, subtitle, captions, axis titles, legend titles), discrete axis tick labels,
discrete legend keys, facet labels, and text from `geom_text`/`geom_label`.
}
\examples{
library(ggplot2)

df <- data.frame(
  day = factor(c("Monday", "Tuesday"), levels = c("Monday", "Tuesday")),
  value = c(10, 12)
)
translation_fr <- list(
  "Monday" = "Lundi",
  "Tuesday" = "Mardi",
  "Weekly Report" = "Rapport Hebdomadaire"
)
p_en <- ggplot(df, aes(x = day, y = value)) +
  geom_col() +
  labs(title = "Weekly Report")
p_fr <- ggtranslate(p_en, translation_fr)
\dontshow{
print(p_fr)
}
}
