% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph-documentation-with-examples.R
\name{gf_text_interactive}
\alias{gf_text_interactive}
\title{Interactive text annotations}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain. Most users can safely ignore this argument.}

\item{gformula}{A formula with shape \code{y ~ x}. Faceting can be achieved by
including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer.}

\item{tooltip}{A formula specifying a variable for tooltips, or a character vector.}

\item{data_id}{A formula or character vector specifying data identifiers
for interactive selection.}

\item{...}{Additional arguments passed to the underlying geom.}

\item{alpha, color, size, shape, fill, group, stroke}{Aesthetics passed to the geom.}

\item{xlab, ylab, title, subtitle, caption}{Labels for the plot.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{show.help}{Logical. If \code{TRUE}, display some minimal help.}

\item{inherit}{Logical. If \code{TRUE}, inherit aesthetics from previous layers.}

\item{environment}{An environment in which to evaluate the formula.}
}
\value{
A gg object that can be displayed with \code{\link[=gf_girafe]{gf_girafe()}}.
}
\description{
Creates an interactive plot using ggiraph. This function extends
\code{\link[=gf_text]{gf_text()}} with interactive features like tooltips and clickable elements.
}
\section{Additional interactive features}{

\itemize{
\item \code{onclick}: JavaScript code (as character string) executed when clicking elements.
\item Additional ggiraph aesthetics may be available depending on the geom.
}
}

\examples{
gf_point_interactive(
  mpg ~ wt, data = mtcars, alpha = 0.4, size = 3,
  tooltip = ~ rownames(mtcars),
  data_id = 1:nrow(mtcars)
) |>
  gf_text_interactive(mpg ~ wt, data = mtcars[1:5, ],
                     label = ~ rownames(mtcars)[1:5],
                     size = 3,
                     angle = 20,
                     data_id = 1:5,
                     tooltip = ~ paste(rownames(mtcars)[1:5], "\nmpg:", mpg, "wt: ", wt)
  ) |>
  gf_girafe()

}
\seealso{
\code{\link[=gf_text]{gf_text()}}, \code{\link[=gf_girafe]{gf_girafe()}}
}
