% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_surround_poly.R
\name{geo_surround_poly}
\alias{geo_surround_poly}
\title{Geo Polygon}
\usage{
geo_surround_poly(coordinates, distance, sides)
}
\arguments{
\item{coordinates}{A vector of the center latitude and longitude point}

\item{distance}{Distance to move away from center for each bearing}

\item{sides}{Number of polygon sides}
}
\value{
Returns a matrix of latitude and longitude points.
}
\description{
Generates a collection of points that are equidistant to the center coordinates given and are distributed equally around the center
}
\examples{

# Load required packages
library(mapview)
library(sp)

# Create sample geo dataset
sample_coord <-
   matrix(
        c(
            sample(327131680:419648450, 1) / 10000000,
            sample(-1147301410:-1241938690, 1) / 10000000
        ),
        ncol = 2
    )

# Create 80 sided polygon based on a random center and radius
geo_poly <- geo_surround_poly(sample_coord, sample(50:500, 1), 80)

# Join all the points into a single matrix
bound_poly <- rbind(sample_coord, geo_poly)

# Create SpacialPoints object and pass to mapview for visualization
mapview(
    SpatialPoints(
        bound_poly[,c(2, 1)],
        proj4string = CRS("+proj=longlat +datum=WGS84")
    )
)


}
\seealso{
\code{\link{geo_sed}} \code{\link{geo_point_dist}}
}
\author{
Shant Sukljian
}
\keyword{circle}
\keyword{disk}
\keyword{enclosing}
\keyword{geo}
\keyword{latitude}
\keyword{longitude}
\keyword{sed}
\keyword{smallest}
