% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer_raster_RData.R
\name{transfer_raster_RData}
\alias{transfer_raster_RData}
\title{Transfer values from a Raster* object to an RData file}
\usage{
transfer_raster_RData(
  inputFile,
  outputPath,
  transferOneFile = TRUE,
  vmode = c("integer", "single", "double")
)
}
\arguments{
\item{inputFile}{character with full path name of input file.}

\item{outputPath}{character with full path name (where the \code{RData} file will be saved). 
No need to provide extension \code{.RData}.}

\item{transferOneFile}{logical, default \code{TRUE} indicates that one file will be transferred.
\code{FALSE} indicates that more than one file will be transferred. See \bold{Details}.}

\item{vmode}{a character specifying the type of virtual storage mode \code{\link[ff]{vmode}} 
needed. Only \code{integer}, \code{single} and \code{double} are allowed.}
}
\value{
At the designated path (\code{outputPath}) the user will find an \code{RData} file.
}
\description{
Get the values of a Raster*, storage them into an \code{\link[base]{array}} and
finally save the array in an \code{RData} which allows for compatibility with multiple 
R functions as well as great portability.
}
\details{
Prior to embark the user in a transfer that may not be successful due to the
lack of RAM, this function provides an estimate of the amount of bytes to be used
in the transfer process. The estimate is obtained by multiplying the number of rows by the number of 
columns by the number of layers of the \code{Raster*} object to transfer by the amount of 
bites used by \code{vmode} (32-bit float for \code{integer} or \code{single} and 
64-bit float for \code{double}). A question is displayed in the console requesting whether
the process should continue. Should the user decide not to continue with the 
importation \code{transfer_raster_RData} returns the message \code{"Did not transfer anything"}.

When \code{transferOneFile=FALSE}, it is assumed that the system has enough RAM to support full files
transfer -no question is asked in the console. This option is useful when this function is used within
a \code{for} loop.
}
\examples{
\donttest{
inputFile = system.file("extdata", "master.tif", package = "geoTS")
outputPath = paste0(system.file("extdata", package = "geoTS"), "/master")
transfer_raster_RData(inputFile = inputFile, outputPath = outputPath, 
                      vmode = "single")
}

}
\seealso{
\code{\link[ff]{vmode}}
}
