% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_flat_file.R
\name{rename_flat_file}
\alias{rename_flat_file}
\title{Rename a flat file}
\usage{
rename_flat_file(flat_file, new_name)
}
\arguments{
\item{flat_file}{Path to the flat file to rename}

\item{new_name}{New name for the flat file}
}
\value{
Used for side effect. Flat file renamed, config file updated,
inflated files modified when needed.
}
\description{
Rename a flat file
}
\examples{
\dontrun{
# These functions change the current user workspace
dev_file <- suppressMessages(
  add_flat_template(
    template = "add",
    pkg = ".",
    overwrite = TRUE,
    open = FALSE
  )
)
rename_flat_file(
  flat_file = "dev/flat_additional.Rmd",
  new_name = "flat_new.Rmd"
)
}
}
