#' @docType data
#'
#' @name otoliths_had
#'
#' @title Otolith Data (Haddock)
#'
#' @description
#' Otolith data for Icelandic haddock from the Icelandic spring bottom trawl
#' survey 2011-2020.
#'
#' @usage
#' otoliths_had
#'
#' @format
#' Data frame containing two columns:
#' \tabular{ll}{
#'   \code{age} \tab age (years)\cr
#'   \code{len} \tab length (cm)
#' }
#'
#' @note
#' The data were contributed by the Icelandic Marine and Freshwater Research
#' Institute. The otoliths were collected following the sampling protocol
#' described in the survey manual (Sólmundsson et al. 2020).
#'
#' @source
#' Sólmundsson, J., Karlsson, H., Björnsson, H., Jónsdóttir, I.G., Jakobsdóttir,
#' K.B., and Bogason, V. (2020).
#' \emph{A manual for the Icelandic groundfish survey in spring 2020}.
#' Marine and Freshwater Research in Iceland HV 2020-08.
#'
#' @seealso
#' \code{\link{gcm}}, \code{\link{gompertz}}, \code{\link{gompertzo}},
#' \code{\link{richards}}, \code{\link{richardso}}, \code{\link{schnute3}},
#' \code{\link{vonbert}}, and \code{\link{vonberto}} are alternative growth
#' models.
#'
#' \code{otoliths_had}, \code{\link{otoliths_skj}}, and \code{\link{tags_skj}}
#' are example datasets.
#'
#' \code{\link{fishgrowth-package}} gives an overview of the package.
#'
#' @examples
#' head(otoliths_had)

NA
