% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervalPOFD.R
\name{intervalPOFD}
\alias{intervalPOFD}
\title{Random Interval Observability}
\usage{
intervalPOFD(data, observability = NULL, ninterval = NULL, pIncomplete = NULL)
}
\arguments{
\item{data}{functional data completely observed. pxn matrix being n the number of curves and p the number og evaluation points.}

\item{observability}{mean observed proportion of the domain where each function is observed.}

\item{ninterval}{if type = "interval", n_interval is an integer with the number of observed intervals 1, 2, 3...
Large values of this parameter requires a large parameter p to guarantee the observability level.}

\item{pIncomplete}{number between 0 and 1 related to the proportion of curves that suffers partially observability.
The default is 1 meaning that all the sample curves are partially observed.}
}
\value{
a list containing two elements 1) a functional sample and 2) the same sample of functions but
partially observed following one of the schemes described in the argument type.
}
\description{
Generates samples of functions observed in different intervals. See Elías et al (2020).
}
\examples{

data <- sapply(1:100, function(x) runif(1)*sin(seq(0, 2*pi, length.out = 200)) +
runif(1)*cos(seq(0, 2*pi, length.out = 200)))

data_pofd <- intervalPOFD(data, observability = 0.5, ninterval = 2, pIncomplete = 1)

}
\references{
Elías, Antonio, Jiménez, Raúl, Paganoni, Anna M. and Sangalli, Laura M. (2020). Integrated Depths for Partially Observed Functional Data.
}
