% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ranef.R
\name{add_ranef}
\alias{add_ranef}
\title{Add random effects to a data frame}
\usage{
add_ranef(.data, .by = NULL, ..., .cors = 0, .empirical = FALSE)
}
\arguments{
\item{.data}{the data frame}

\item{.by}{the grouping column (groups by row if NULL)}

\item{...}{the name and standard deviation of each random effect}

\item{.cors}{the correlations among multiple random effects, to be passed to \code{\link{rnorm_multi}} as r}

\item{.empirical}{logical. To be passed to \code{\link{rnorm_multi}} as empirical}
}
\value{
data frame with new random effects columns
}
\description{
Add random effects to a data frame
}
\examples{
add_random(rater = 2, stimulus = 2, time = 2) \%>\%
  add_ranef("rater", u0r = 1.5) \%>\%
  add_ranef("stimulus", u0s = 2.2, u1s = 0.75, .cors = 0.5) \%>\%
  add_ranef(c("rater", "stimulus"), u0sr = 1.2)
}
