% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fui.R
\name{fui}
\alias{fui}
\title{Fast Univariate Inference for Longitudinal Functional Models}
\usage{
fui(
  formula,
  data,
  family = "gaussian",
  var = TRUE,
  analytic = TRUE,
  parallel = FALSE,
  silent = FALSE,
  argvals = NULL,
  nknots_min = NULL,
  nknots_min_cov = 35,
  smooth_method = "GCV.Cp",
  splines = "tp",
  design_mat = FALSE,
  residuals = FALSE,
  num_boots = 500,
  boot_type = NULL,
  seed = 1,
  subj_ID = NULL,
  num_cores = 1,
  caic = FALSE,
  REs = FALSE,
  non_neg = 0,
  MoM = 1,
  impute_outcome = FALSE
)
}
\arguments{
\item{formula}{Two-sided formula object in lme4 formula syntax.
The difference is that the response need to be specified as a matrix
instead of a vector. Each column of the matrix represents one location
of the longitudinal functional observations on the domain.}

\item{data}{A data frame containing all variables in formula}

\item{family}{GLM family of the response. Defaults to \code{gaussian}.}

\item{var}{Logical, indicating whether to calculate and return variance
of the coefficient estimates. Defaults to \code{TRUE}.}

\item{analytic}{Logical, indicating whether to use the analytic inferenc
approach or bootstrap. Defaults to \code{TRUE}.}

\item{parallel}{Logical, indicating whether to do parallel computing.
Defaults to \code{FALSE}.}

\item{silent}{Logical, indicating whether to show descriptions of each step.
Defaults to \code{FALSE}.}

\item{argvals}{A vector containing locations of observations on the
functional domain. If not specified, a regular grid across the range of
the domain is assumed. Currently only supported for bootstrap
(\code{analytic=FALSE}).}

\item{nknots_min}{Minimal number of knots in the penalized smoothing for the
regression coefficients.
Defaults to \code{NULL}, which then uses L/2 where L is the dimension of the
functional domain.}

\item{nknots_min_cov}{Minimal number of knots in the penalized smoothing for
the covariance matrices.
Defaults to \code{35}.}

\item{smooth_method}{How to select smoothing parameter in step 2. Defaults to
\code{"GCV.Cp"}}

\item{splines}{Spline type used for penalized splines smoothing. We use the
same syntax as the mgcv package. Defaults to \code{"tp"}.}

\item{design_mat}{Logical, indicating whether to return the design matrix.
Defaults to \code{FALSE}}

\item{residuals}{Logical, indicating whether to save residuals from
unsmoothed LME. Defaults to \code{FALSE}.}

\item{num_boots}{Number of samples when using bootstrap inference. Defaults
to 500.}

\item{boot_type}{Bootstrap type (character): "cluster", "case", "wild",
"reb", "residual", "parametric", "semiparametric". \code{NULL} defaults to
"cluster" for non-gaussian responses and "wild" for gaussian responses. For
small cluster (n<=10) gaussian responses, defaults to "reb".}

\item{seed}{Numeric value used to make sure bootstrap replicate (draws) are
correlated across functional domains for certain bootstrap approach}

\item{subj_ID}{Name of the variable that contains subject ID.}

\item{num_cores}{Number of cores for parallelization. Defaults to 1.}

\item{caic}{Logical, indicating whether to calculate cAIC. Defaults to
\code{FALSE}.}

\item{REs}{Logical, indicating whether to return random effect estimates.
Defaults to \code{FALSE}.}

\item{non_neg}{0 - no non-negativity constrains, 1 - non-negativity
constraints on every coefficient for variance, 2 - non-negativity on
average of coefficents for 1 variance term. Defaults to 0.}

\item{MoM}{Method of moments estimator. Defaults to 1.}

\item{impute_outcome}{Logical, indicating whether to impute missing outcome
values with FPCA. This has not been tested thoroughly so use with caution.
Defaults to \code{FALSE}.}
}
\value{
A list containing:
\item{betaHat}{Estimated functional fixed effects}
\item{argvals}{Location of the observations}
\item{betaHat.var}{Variance estimates of the functional fixed effects (if specified)}
\item{qn}{critical values used to construct joint CI}
\item{...}{...}
}
\description{
Fit a function-on-scalar regression model for longitudinal
functional outcomes and scalar predictors using the Fast Univariate
Inference (FUI) approach (Cui et al. 2022; Loewinger et al. 2024).
}
\details{
The FUI approach comprises of three steps:
\enumerate{
\item Fit a univariate mixed model at each location of the functional domain,
and obtain raw estimates from massive models;
\item Smooth the raw estimates along the functional domain;
\item Obtain the pointwise and joint confidence bands using an analytic
approach for Gaussian data or Bootstrap for general distributions.
}

For more information on each step, please refer to the FUI paper
by Cui et al. (2022). For more information on the method of moments estimator 
applied in step 3, see Loewinger et al. (2024).
}
\examples{
library(refund)

## random intercept only
set.seed(1)
DTI_use <- DTI[DTI$ID \%in\% sample(DTI$ID, 10),]
fit_dti <- fui(
  cca ~ case + visit + sex + (1 | ID),
  data = DTI_use
)
}
\references{
Cui, E., Leroux, A., Smirnova, E., Crainiceanu, C. (2022). Fast
Univariate Inference for Longitudinal Functional Models. \emph{Journal of
Computational and Graphical Statistics}, 31(1), 219-230.

Loewinger, G., Cui, E., Lovinger, D., Pereira, F. (2024). A 
Statistical Framework for Analysis of Trial-Level Temporal Dynamics in 
Fiber Photometry Experiments. \emph{eLife}, 95802.
}
\author{
Erjia Cui \email{ecui@umn.edu}, Gabriel Loewinger
\email{gloewinger@gmail.com}
}
