# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Utility operations
#' @description factset.analyticsapi.engines
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ GetByUrl } \emph{ Url of the GET endpoint }
#' This function can be used to fetch data from any Get endpoint.
#'
#' \itemize{
#' \item \emph{ @param } url character
#' \item \emph{ @returnType } raw  
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response once the request is successful. Response body will contain the data.
#'
#' \item return type : raw 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
#' }
#' \item status code : 400 | Invalid identifier provided.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  GetByUrl  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.url <- url # character | Url of the GET endpoint
#'
#' # Get by url
#' api.instance <- UtilityApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetByUrl(url = var.url),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @importFrom rlang abort
#' @export
UtilityApi <- R6::R6Class(
  'UtilityApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    GetByUrl = function(url, ...){
      apiResponse <- self$GetByUrlWithHttpInfo(url, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetByUrlWithHttpInfo = function(url, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`url`)) {
        rlang::abort(message = "Missing required parameter `url`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `url`."))
      }

      headerParams['Accept'] <- "application/x-protobuf, text/plain, application/json, text/json"

      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = url,
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        content <- httr::content(resp, "raw")
        ApiResponse$new(content, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    }
  )
)