% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-mean_spec.R
\name{mean_spec}
\alias{mean_spec}
\title{Specification of Conditional Mean Models}
\usage{
mean_spec(orders = c(0, 0), long_memo = FALSE, include_mean = TRUE)
}
\arguments{
\item{orders}{a two-element numeric vector with the model
orders; the first element is the autoregressive order \eqn{p^{*}}, while
the second element is the moving-average order \eqn{q^{*}}.}

\item{long_memo}{a logical value that indicates whether the
long-memory version of the model should be considered or not.}

\item{include_mean}{a logical value indicating whether or
not to include the constant unconditional mean in the estimation
procedure; for \code{include_mean = FALSE}, the unconditional
mean of the series is fixed to zero and not being estimated.}
}
\value{
An object of class \code{"mean_spec"} is returned.
}
\description{
Specify the model for the conditional mean in a dual model, where the
conditional mean is modelled through an ARMA or a FARIMA model and the
conditional standard deviations through a GARCH-type model simultaneously.
}
\details{
Let \eqn{\left\{y_t\right\}}, with \eqn{t \in \mathbb{Z}} as the time index,
be a theoretical time series that follows
\deqn{\beta(B)(1- B)^{D}(y_t - \mu)=\alpha(B)r_t,}
where \eqn{\beta(B) = 1 - \sum_{i=1}^{p^{*}}\beta_i B^{i}} and
\eqn{\alpha(B) = 1 + \sum_{j=1}^{q^{*}}\alpha_j B^{j}} are the AR- and MA-polynomials
of orders \eqn{p^{*}} and \eqn{q^{*}}, respectively, with real coefficients
\eqn{\beta_i}, \eqn{i=1,\dots,p^{*}}, and \eqn{\alpha_j}, \eqn{j=1,\dots,q^{*}}.
\eqn{B} is the backshift operator. \eqn{\beta(B)} and \eqn{\alpha(B)} are
commonly assumed to be without common roots and to have roots outside of
the unit circle.
Furthermore, \eqn{\mu} is a real-valued coefficient representing the unconditional
mean in \eqn{\left\{y_t\right\}}. \eqn{D \in [0, 0.5)} is the fractional
differencing parameter. \eqn{\left\{r_t\right\}} is a zero-mean (weak) white
noise process, for example a member of the GARCH-models (with mean set to zero)
presented in this package (see the
descriptions in \link{fEGarch_spec}, \link{fiaparch}, \link{figarch}, etc.).

The for \eqn{D=0}, which can be achieved through \code{long_memo = FALSE},
the formulas above describe an autoregressive moving-average (ARMA) model.
For \eqn{D \in (0, 0.5)}, they describe a fractionally integrated ARMA (FARIMA)
model.
}
\examples{
mean_spec()
mean_spec(orders = c(1, 1))

}
