% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-bin.R
\name{bin_pupil}
\alias{bin_pupil}
\title{Bin pupil data into specified time bins}
\usage{
bin_pupil(x, prev_op, bins_per_second, method, current_fs)
}
\arguments{
\item{x}{A data frame containing the pupil time series data}

\item{prev_op}{The name of the previous operation's output column}

\item{bins_per_second}{Number of bins per second (positive integer)}

\item{method}{Aggregation method: "mean" or "median"}

\item{current_fs}{Current sampling rate in Hz}
}
\value{
A data frame with binned pupil data containing columns:
\itemize{
\item \code{time_secs}: Bin center timestamps
\item \verb{pupil_binned_\{method\}_\{bins_per_second\}hz}: Binned pupil values
}
}
\description{
This function bins pupil data into specified time bins using either mean or
median aggregation. It creates evenly spaced bins across the time series and
aggregates pupil values within each bin.
}
\details{
This function is called by the exposed wrapper \code{\link[=bin]{bin()}}.
}
\keyword{internal}
