% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radf-methods.R
\name{diagnostics}
\alias{diagnostics}
\alias{diagnostics.radf_obj}
\title{Diagnostics on hypothesis testing}
\usage{
diagnostics(object, cv = NULL, ...)

\method{diagnostics}{radf_obj}(object, cv = NULL, option = c("gsadf", "sadf"), ...)
}
\arguments{
\item{object}{An object of class \code{obj}.}

\item{cv}{An object of class \code{cv}.}

\item{...}{Further arguments passed to methods.}

\item{option}{Whether to apply the "gsadf" or "sadf" methodology (default = "gsadf").}
}
\value{
Returns a list with the series that reject (positive) and the series
that do not reject (negative) the null hypothesis, and at what significance level.
}
\description{
Provides information on whether the null hypothesis of a unit root is rejected
against the alternative of explosive behaviour for each series in a dataset.
}
\details{
Diagnostics also stores a vector whose elements take the value of 1 when
there is a period of explosive behaviour and 0 otherwise.
}
\examples{

rsim_data <- radf(sim_data)
diagnostics(rsim_data)

diagnostics(rsim_data, option = "sadf")
}
