% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveCSV.R
\name{saveCSV}
\alias{saveCSV}
\title{Fastly save CSV file within a current date folder}
\usage{
saveCSV(df,
        dir = "results",
        filename = "output",
        verbose = TRUE,
        append = FALSE,
        save = TRUE,
        foldername = NULL)
}
\arguments{
\item{df}{Any input list of same length vectors (e.g. \code{data.frame} and
\code{data.table}).}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results} and the input \code{data.frame}
will be saved within a subfolder named after the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{output}.}

\item{verbose}{Logical, if \code{FALSE}, a message showing the saving process
will not be printed in the console in full.}

\item{append}{Logical, if \code{TRUE}, the file is opened in append mode and
column names (header row) are not written.}

\item{save}{Logical, if \code{FALSE}, the input \code{data.frame} will be not
be saved on disk.}

\item{foldername}{A parameter only for internal use with
\href{https://dboslab.github.io/expowo/}{expowo}'s main functions. You must keep
this always as \code{NULL}.}
}
\description{
Uses \code{fwrite} to fastly write a CSV file within a current
date subfolder of a provided specific directory.
}
\examples{
\donttest{
library(expowo)

res <- powoGenera(family = "Lecythidaceae",
                  verbose = TRUE,
                  save = FALSE)

saveCSV(res,
        dir = "results_powoGenera",
        filename = "Lecythidaceae_search",
        append = FALSE)
}

}
\author{
Debora Zuanny & Domingos Cardoso
}
