% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_data.R
\name{CImu_data}
\alias{CImu_data}
\alias{dcimu}
\title{Confidence Intervals}
\usage{
CImu_data(
  x = NULL,
  n = length(x),
  xbar = NULL,
  sd = NULL,
  conf.level = c(0.9, 0.95, 0.99),
  mu = NULL,
  sigma = NULL
)

dcimu(
  x = NULL,
  n = length(x),
  xbar = NULL,
  sd = NULL,
  conf.level = c(0.9, 0.95, 0.99),
  mu = NULL,
  sigma = NULL
)
}
\arguments{
\item{x}{numeric: vector of data values}

\item{n}{numeric: length of the vector x (if \code{n<1} then \code{n=5} is used)}

\item{xbar}{numeric: sample mean}

\item{sd}{numeric: sample standard deviation}

\item{conf.level}{numeric: vector of confidence levels of the interval (default: \code{c(0.9, 0.95, 0.99)})}

\item{mu}{numeric: true value of the mean}

\item{sigma}{numeric: vector of possible variance}
}
\value{
a list with
\itemize{
\item \code{a} with \code{1-(1-conf.level)/2}
\item \code{n} number observations if given
\item \code{xbar} mean of observations if not given
\item \code{mu} theoretical mean if given
\item \code{sd} standard deviation of observations
\item \code{sigma} theoretical standard deviation if given
\item \code{df} degrees of freedom if a \code{t} distribution is used
\item \code{q} if \code{sigma=NULL}
\item \code{ss} either \code{sd} or \code{sigma}
\item \code{e} margin of error (half of the length of the confidence interval(s))
\item \code{l} length of the confidence interval(s)
\item \code{v} endpoints of the confidence interval(s)
}
}
\description{
The \code{CImu_data} function is designed for the generation of confidence intervals pertaining to a population mean \code{mu}.
The function accommodates scenarios in which a dataset \code{x} is either provided or generated through a random sampling process
from a normal distribution, with user-specified parameters such as a mean \code{mu} and a standard deviation \code{sigma}.
Subsequently, the function computes essential statistical measures, including the sample mean \code{xbar} and the standard deviation \code{sd}.
Confidence intervals for the population mean are then calculated at user-defined confidence levels (\code{conf.level}).
The output is a structured list containing pertinent statistics, encompassing the mean, sample standard deviation,
confidence intervals, and other relevant details.
}
\examples{
# with data
x <- rnorm(100)
CImu_data(x, conf.level=0.95)
# simulate data internally
CImu_data(n=100, conf.level=0.95, mu=0, sigma=1)
}
