% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5dmap.R
\name{eq5dmap}
\alias{eq5dmap}
\title{Calculate utility index scores by mapping between EQ-5D-3L and EQ-5D-5L}
\usage{
eq5dmap(scores, country, version, age, sex, bwidth = 0, digits = 3)
}
\arguments{
\item{scores}{numeric with names MO, SC, UA, PD and AD representing
Mobility, Self-care, Usual activities, Pain/discomfort and Anxiety/depression. 
or a utility index score}

\item{country}{value set country}

\item{version}{string of value "3L" or "5L" to indicate starting instrument version.}

\item{age}{age in years (18-100), or age category (1: 18-34, 2: 35-44, 3: 45-54, 4: 55-64, 5: 65-100)}

\item{sex}{Male or Female}

\item{bwidth}{bandwith score for approximate scores (< 0.8: 0.2, 0.8-0.951: 0.1, 0.951-1: small, but large enough to include 1)}

\item{digits}{number of decimal places to return}
}
\value{
calculated utility index score.
}
\description{
Conditional prediction of the utility values of 5L scores onto 3L value 
sets and 3L scores onto 5L value sets from observed or specified values 
conditional on age and gender using the NICE Decision Support Unit's EEPRU
funded models (see \href{https://www.sheffield.ac.uk/nice-dsu/methods-development/mapping-eq-5d-5l-3l}{NICE DSU}'s
website for more information).
}
\details{
Available value sets can be viewed using the function \code{valuesets}.
}
\examples{
eq5dmap(c(MO=1,SC=2,UA=3,PD=4,AD=5), "UK", "5L", 30, "female")
eq5dmap(0.922, "UK", "5L", 18, "male")
eq5dmap(0.715, "UK", "5L", 50, "male", bwidth = 0.0001)
eq5dmap(0.715, "UK", "5L", 50, "male", bwidth = 0.0001, digits = 8)

}
