% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-selection.R
\name{PPP}
\alias{PPP}
\alias{PPP.edina}
\title{Posterior Predictive Probabilities (PPPs)}
\usage{
PPP(object, ...)

\method{PPP}{edina}(object, alpha = 0.05, ...)
}
\arguments{
\item{object}{An \code{edina} object}

\item{...}{Not used.}

\item{alpha}{Defining region to indicate the level of extremeness
the data must before the model is problematic.}
}
\value{
The PPP value given the specified \code{alpha} value.
}
\description{
Computes posterior predictive probabilities (PPPs) based on the
odds ratios for each pair of items.
}
\details{
PPPs that smaller than 0.05 or greater than 0.95 tend to be extreme and
evidence of misfit. As a result, this is more of a heuristic metric.
}
\section{PPP Computation Procedure}{

\enumerate{
\item simulate observed responses \eqn{\mathbf Y^{(r)}} using model parameters
from iteration \eqn{r} of the MCMC sampler
\item computing the odds ratio for each pair of items at iteration \eqn{r} as
\deqn{OR^{(r)} = n_{11}^{(r)}n_{00}^{(r)}/\left(n_{10}^{(r)}n_{01}^{(r)}\right)},
where \eqn{n_{11}^{(r)}} is the frequency of ones on both variables at
iteration \eqn{r}, \eqn{n_{10}^{(r)}} is the frequency of ones on the
first item and zeros on the second at iteration \eqn{r}, etc.; and
\item computing PPPs for each item pair as the proportion of generated
\eqn{OR^{(r)}}'s that exceeded elements of the observed odds ratios.
}
}

